//   ___________		     _________		      _____  __
//   \_	  _____/______   ____   ____ \_   ___ \____________ _/ ____\/  |_
//    |    __) \_  __ \_/ __ \_/ __ \/    \  \/\_  __ \__  \\   __\\   __\ 
//    |     \   |  | \/\  ___/\  ___/\     \____|  | \// __ \|  |   |  |
//    \___  /   |__|    \___  >\___  >\______  /|__|  (____  /__|   |__|
//	  \/		    \/	   \/	     \/		   \/
//  ______________________                           ______________________
//			  T H E   W A R   B E G I N S
//	   FreeCraft - A free fantasy real time strategy game engine
//
/**@name tileset.c	-	The tileset. */
//
//	(c) Copyright 1998-2000 by Lutz Sammer
//
//	$Id: tileset.c,v 1.5 2000/08/13 16:23:02 johns Exp $

//@{

/*----------------------------------------------------------------------------
--	Includes
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "freecraft.h"
#include "tileset.h"
#include "map.h"

/*----------------------------------------------------------------------------
--	Variables
----------------------------------------------------------------------------*/

extern int WoodTable[16];		/// Table for wood removable.
extern int RockTable[20];		/// Table for rock removable.

/**
**	Mapping of wc numbers to our internal symbols.
**	The numbers are used in puds.
**	0=summer, 1=winter, 2=wasteland, 3=swamp.
*/
global char** TilesetWcNames;

#if 1		//	FIXME: only support ccl version.

/**
**	Table to convert summer pud tile numbers to internal.
*/
local const unsigned short TileTableSummer[0x9E0] = {
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x148,0x149,0x149,0x14A,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x14B,0x14C,0x14C,0x14D,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x14E,0x14F,0x150,0x000,0x151,0x152,0x153,0x154,
 0x155,0x156,0x157,0x158,0x000,0x000,0x000,0x000,
 0x159,0x15A,0x15B,0x000,0x15C,0x15D,0x15E,0x15F,
 0x160,0x161,0x162,0x163,0x000,0x000,0x000,0x000,
 0x164,0x165,0x164,0x000,0x166,0x167,0x168,0x169,
 0x16A,0x16B,0x166,0x167,0x166,0x167,0x166,0x167,
 0x16C,0x16D,0x16C,0x000,0x16E,0x16F,0x170,0x171,
 0x172,0x173,0x16E,0x16F,0x16E,0x16F,0x16E,0x16F,
 0x07D,0x07F,0x080,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0A5,0x0B1,0x0B2,0x0B3,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x010,0x000,0x034,0x000,0x058,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x022,0x000,0x046,0x000,0x058,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x021,0x000,0x045,0x000,0x065,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x033,0x000,0x057,0x000,0x065,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x12C,0x12D,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x12E,0x12F,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x130,0x131,0x132,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x133,0x134,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x135,0x136,0x137,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x138,0x139,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x13A,0x13A,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x13B,0x13C,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x13D,0x13E,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x13F,0x140,0x141,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x142,0x142,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x143,0x144,0x145,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x146,0x146,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x147,0x147,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0CE,0x0CF,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0D0,0x0D1,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0D2,0x0D3,0x0D4,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0D5,0x0D6,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0D7,0x0D8,0x0D9,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0DA,0x0DA,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0DB,0x0DC,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0DD,0x0DE,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0DF,0x0DF,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0E0,0x0E1,0x0E2,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0E3,0x0E4,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0E5,0x0E6,0x0E7,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0E8,0x0E9,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0EA,0x0EB,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0B4,0x0B4,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0B5,0x0B6,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0B7,0x0B8,0x0B9,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0BA,0x0BA,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0BB,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0BC,0x0BD,0x0BE,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0BF,0x0C0,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0C1,0x0C1,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0C2,0x0C2,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0C3,0x0C4,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0C5,0x0C6,0x0C7,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0C8,0x0C8,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0C9,0x0CA,0x0CB,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0CC,0x0CC,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0CD,0x0CD,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x096,0x0AD,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x08E,0x0A7,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0A4,0x0B0,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x093,0x0AB,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x095,0x0AC,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x0BB,0x000,0x000,0x000,0x000,
 0x09A,0x0AF,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x097,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x090,0x0A9,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x099,0x0AE,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x08F,0x0A8,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x098,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x092,0x0AA,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x094,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x091,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x10E,0x10F,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x110,0x111,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x112,0x113,0x114,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x115,0x116,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x117,0x118,0x119,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x11A,0x11B,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x11C,0x11C,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x11D,0x11E,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x11F,0x120,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x121,0x122,0x123,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x124,0x124,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x125,0x126,0x127,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x128,0x129,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x12A,0x12B,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0EE,0x0EF,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0F0,0x0F1,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0F2,0x0F3,0x0F4,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0F5,0x0F6,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0F7,0x0F8,0x0F9,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0FA,0x0FB,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0FC,0x0FD,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0FE,0x0FF,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x100,0x101,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x102,0x103,0x104,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x105,0x106,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x107,0x108,0x109,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x10A,0x10B,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x10C,0x10D,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x081,0x06E,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x066,0x082,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x07C,0x083,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x06B,0x084,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x085,0x06D,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x08B,0x08A,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x06F,0x06F,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x068,0x088,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x08C,0x08D,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x067,0x087,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x070,0x070,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x06A,0x086,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x089,0x089,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x069,0x069,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x011,0x000,0x035,0x000,0x059,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x012,0x000,0x036,0x000,0x05A,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x013,0x000,0x037,0x000,0x05B,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x014,0x000,0x038,0x000,0x05C,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x015,0x016,0x000,0x039,0x03A,0x000,0x05D,0x05F,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x017,0x000,0x03B,0x000,0x05E,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x018,0x000,0x03C,0x000,0x05D,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x019,0x000,0x03D,0x000,0x060,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x01A,0x000,0x03E,0x000,0x061,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x01B,0x01C,0x000,0x03F,0x040,0x000,0x062,0x063,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x01D,0x000,0x041,0x000,0x062,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x01E,0x000,0x042,0x000,0x064,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x01F,0x000,0x043,0x000,0x05F,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x020,0x000,0x044,0x000,0x063,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x023,0x000,0x047,0x000,0x059,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x024,0x000,0x048,0x000,0x05A,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x025,0x000,0x049,0x000,0x05B,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x026,0x000,0x04A,0x000,0x05C,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x027,0x028,0x000,0x04B,0x04C,0x000,0x05D,0x05F,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x029,0x000,0x04D,0x000,0x05E,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x02A,0x000,0x04E,0x000,0x05D,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x02B,0x000,0x04F,0x000,0x060,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x02C,0x000,0x050,0x000,0x061,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x02D,0x02E,0x000,0x051,0x052,0x000,0x062,0x063,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x02F,0x000,0x053,0x000,0x062,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x030,0x000,0x054,0x000,0x064,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x031,0x000,0x055,0x000,0x05F,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x032,0x000,0x056,0x000,0x063,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
};

/**
**	Table to convert winter pud tile numbers to internal.
*/
local const unsigned short TileTableWinter[0x9E0] = {
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x13F,0x140,0x140,0x141,0x000,0x142,0x143,0x144,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x145,0x146,0x146,0x147,0x000,0x148,0x149,0x14A,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x14B,0x14C,0x14D,0x000,0x14E,0x14F,0x150,0x151,
 0x152,0x153,0x14E,0x152,0x000,0x000,0x000,0x000,
 0x154,0x155,0x156,0x000,0x157,0x158,0x159,0x15A,
 0x15B,0x15C,0x157,0x15B,0x000,0x000,0x000,0x000,
 0x15D,0x15E,0x15F,0x000,0x160,0x161,0x162,0x163,
 0x164,0x165,0x166,0x167,0x168,0x169,0x16A,0x16B,
 0x16C,0x16D,0x16E,0x000,0x16F,0x170,0x171,0x172,
 0x173,0x174,0x175,0x176,0x177,0x178,0x179,0x17A,
 0x07D,0x087,0x088,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0A0,0x0AC,0x0AD,0x0AE,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x010,0x000,0x034,0x000,0x058,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x022,0x000,0x046,0x000,0x058,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x021,0x000,0x045,0x000,0x065,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x033,0x000,0x057,0x000,0x065,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x123,0x124,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x125,0x126,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x127,0x128,0x129,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x12A,0x12B,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x12C,0x12D,0x12E,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x12F,0x130,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x131,0x131,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x132,0x133,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x134,0x135,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x136,0x137,0x138,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x139,0x139,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x13A,0x13B,0x13C,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x13D,0x13D,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x13E,0x13E,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0C7,0x0C8,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0C9,0x0CA,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0CB,0x0CC,0x0CD,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0CE,0x0CF,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0D0,0x0D1,0x0D2,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0D3,0x0D3,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0D4,0x0D5,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0D6,0x0D7,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0D8,0x0D8,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0D9,0x0DA,0x0DB,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0DC,0x0DD,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0DE,0x0DF,0x0E0,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0E1,0x0E2,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0E3,0x0E4,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0AF,0x0B0,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0B1,0x0B2,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0B3,0x0B4,0x0B3,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0B5,0x0B6,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0B7,0x0B8,0x0B7,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0B9,0x0BA,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0BB,0x0BB,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0BC,0x0BD,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0BE,0x0BF,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0C0,0x0C1,0x0C0,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0C2,0x0C2,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0C3,0x0C4,0x0C3,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0C5,0x0C5,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0C6,0x0C6,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x091,0x0A8,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x089,0x0A2,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x09F,0x0AB,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x08E,0x0A6,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x090,0x0A7,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x095,0x0AA,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x092,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x08B,0x0A4,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x094,0x0A9,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x08A,0x0A3,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x093,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x08D,0x0A5,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x08F,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x08C,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x103,0x104,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x105,0x106,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x107,0x108,0x109,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x10A,0x10B,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x10C,0x10D,0x10E,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x10F,0x110,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x111,0x112,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x113,0x114,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x115,0x116,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x117,0x118,0x119,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x11A,0x11B,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x11C,0x11D,0x11E,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x11F,0x120,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x121,0x122,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0E7,0x0E8,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0E9,0x0EA,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0EB,0x0EC,0x0ED,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0EE,0x0EF,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0F0,0x0F1,0x0F2,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0F3,0x0F4,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0F5,0x0F5,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0F6,0x0F7,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0F8,0x0F9,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0FA,0x0FB,0x0FC,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0FD,0x0FD,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0FE,0x0FF,0x100,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x101,0x101,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x102,0x102,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x06E,0x085,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x066,0x07F,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x07C,0x086,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x06B,0x083,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x06D,0x084,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x072,0x072,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x06F,0x06F,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x068,0x081,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x071,0x071,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x067,0x080,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x070,0x070,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x06A,0x082,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x06C,0x06C,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x069,0x069,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x011,0x000,0x035,0x000,0x059,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x012,0x000,0x036,0x000,0x05A,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x013,0x000,0x037,0x000,0x05B,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x014,0x000,0x038,0x000,0x05C,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x015,0x016,0x000,0x039,0x03A,0x000,0x05E,0x063,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x017,0x000,0x03B,0x000,0x05D,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x018,0x000,0x03C,0x000,0x05E,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x019,0x000,0x03D,0x000,0x05F,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x01A,0x000,0x03E,0x000,0x060,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x01B,0x01C,0x000,0x03F,0x040,0x000,0x061,0x064,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x01D,0x000,0x041,0x000,0x061,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x01E,0x000,0x042,0x000,0x062,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x01F,0x000,0x043,0x000,0x063,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x020,0x000,0x044,0x000,0x064,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x023,0x000,0x047,0x000,0x059,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x024,0x000,0x048,0x000,0x05A,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x025,0x000,0x049,0x000,0x05B,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x026,0x000,0x04A,0x000,0x05C,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x027,0x028,0x000,0x04B,0x04C,0x000,0x05E,0x063,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x029,0x000,0x04D,0x000,0x05D,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x02A,0x000,0x04E,0x000,0x05E,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x02B,0x000,0x04F,0x000,0x05F,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x02C,0x000,0x050,0x000,0x060,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x02D,0x02E,0x000,0x051,0x052,0x000,0x061,0x064,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x02F,0x000,0x053,0x000,0x061,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x030,0x000,0x054,0x000,0x062,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x031,0x000,0x055,0x000,0x063,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x032,0x000,0x056,0x000,0x064,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
};

/**
**	Table to convert swamp pud tile numbers to internal.
*/
local const unsigned short TileTableSwamp[0x9E0] = {
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x14A,0x14B,0x14B,0x14C,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x14D,0x14E,0x14E,0x14F,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x150,0x151,0x152,0x000,0x153,0x154,0x155,0x156,
 0x157,0x158,0x000,0x000,0x000,0x000,0x000,0x000,
 0x159,0x15A,0x15B,0x000,0x15C,0x15D,0x15E,0x15F,
 0x160,0x161,0x000,0x000,0x000,0x000,0x000,0x000,
 0x162,0x163,0x164,0x000,0x165,0x166,0x167,0x168,
 0x169,0x16A,0x16B,0x16C,0x16D,0x16E,0x16F,0x170,
 0x171,0x172,0x173,0x000,0x174,0x175,0x176,0x177,
 0x178,0x179,0x17A,0x17B,0x17C,0x17D,0x17E,0x17F,
 0x07D,0x087,0x088,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0A0,0x0AC,0x0AD,0x0AE,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x010,0x000,0x034,0x000,0x058,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x022,0x000,0x046,0x000,0x058,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x021,0x000,0x045,0x000,0x065,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x033,0x000,0x057,0x000,0x065,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x12E,0x12E,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x12F,0x12F,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x130,0x131,0x132,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x133,0x133,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x134,0x135,0x136,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x137,0x138,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x139,0x13A,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x13B,0x13B,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x13C,0x13D,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x13E,0x13F,0x140,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x141,0x142,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x143,0x144,0x145,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x146,0x147,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x148,0x149,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0CF,0x0D0,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0D1,0x0D2,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0D3,0x0D4,0x0D5,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0D6,0x0D7,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0D8,0x0D9,0x0DA,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0DB,0x0DB,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0DC,0x0DD,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0DE,0x0DF,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0E0,0x0E0,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0E1,0x0E2,0x0E3,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0E4,0x0E5,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0E6,0x0E7,0x0E8,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0E9,0x0EA,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0EB,0x0EC,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0AF,0x0B0,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0B1,0x0B2,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0B3,0x0B4,0x0B5,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0B6,0x0B7,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0B8,0x0B9,0x0BA,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0BB,0x0BC,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0BD,0x0BE,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0BF,0x0C0,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0C1,0x0C2,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0C3,0x0C4,0x0C5,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0C6,0x0C7,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0C8,0x0C9,0x0CA,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0CB,0x0CC,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0CD,0x0CE,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x091,0x0A8,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x089,0x0A2,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x09F,0x0AB,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x08E,0x0A6,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x090,0x0A7,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x095,0x0AA,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x092,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x08B,0x0A4,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x094,0x0A9,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x08A,0x0A3,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x093,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x08D,0x0A5,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x08F,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x08C,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x10E,0x10F,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x110,0x111,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x112,0x113,0x114,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x115,0x116,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x117,0x118,0x119,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x11A,0x11B,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x11C,0x11D,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x11E,0x11F,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x120,0x121,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x122,0x123,0x124,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x125,0x126,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x127,0x128,0x129,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x12A,0x12B,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x12C,0x12D,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0EF,0x0F0,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0F1,0x0F2,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0F3,0x0F4,0x0F5,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0F6,0x0F7,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0F8,0x0F9,0x0FA,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0FB,0x0FC,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0FD,0x0FD,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0FE,0x0FF,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x100,0x101,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x102,0x103,0x104,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x105,0x105,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x106,0x107,0x108,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x109,0x109,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x10A,0x10A,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x06E,0x085,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x066,0x07F,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x07C,0x086,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x06B,0x083,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x06D,0x084,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x072,0x072,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x06F,0x06F,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x068,0x081,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x071,0x071,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x067,0x080,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x070,0x070,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x06A,0x082,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x06C,0x06C,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x069,0x069,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x011,0x000,0x035,0x000,0x059,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x012,0x000,0x036,0x000,0x05A,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x013,0x000,0x037,0x000,0x05B,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x014,0x000,0x038,0x000,0x05C,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x015,0x016,0x000,0x039,0x03A,0x000,0x05D,0x05F,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x017,0x000,0x03B,0x000,0x05E,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x018,0x000,0x03C,0x000,0x05D,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x019,0x000,0x03D,0x000,0x060,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x01A,0x000,0x03E,0x000,0x061,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x01B,0x01C,0x000,0x03F,0x040,0x000,0x062,0x063,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x01D,0x000,0x041,0x000,0x062,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x01E,0x000,0x042,0x000,0x064,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x01F,0x000,0x043,0x000,0x05F,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x020,0x000,0x044,0x000,0x063,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x023,0x000,0x047,0x000,0x059,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x024,0x000,0x049,0x000,0x05A,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x025,0x000,0x049,0x000,0x05B,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x026,0x000,0x04D,0x000,0x05C,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x027,0x028,0x000,0x04B,0x04C,0x000,0x05D,0x05F,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x029,0x000,0x04D,0x000,0x05E,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x02A,0x000,0x04E,0x000,0x05D,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x02B,0x000,0x04F,0x000,0x060,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x02C,0x000,0x050,0x000,0x061,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x02D,0x02E,0x000,0x051,0x052,0x000,0x062,0x063,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x02F,0x000,0x053,0x000,0x062,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x030,0x000,0x054,0x000,0x064,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x031,0x000,0x055,0x000,0x05F,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x032,0x000,0x056,0x000,0x063,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
};

/**
**	Table to convert wasteland pud tile numbers to internal.
*/
local const unsigned short TileTableWasteland[0x9E0] = {
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x144,0x145,0x145,0x146,0x000,0x144,0x145,0x145,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x147,0x148,0x148,0x149,0x000,0x147,0x148,0x148,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x14A,0x14B,0x14C,0x000,0x14D,0x14E,0x14F,0x150,
 0x151,0x152,0x14E,0x150,0x000,0x000,0x000,0x000,
 0x153,0x154,0x155,0x000,0x156,0x157,0x158,0x159,
 0x156,0x157,0x154,0x155,0x000,0x000,0x000,0x000,
 0x15A,0x15B,0x15C,0x000,0x15D,0x15E,0x15F,0x160,
 0x161,0x162,0x163,0x164,0x165,0x166,0x167,0x168,
 0x105,0x106,0x107,0x000,0x169,0x16A,0x16B,0x16C,
 0x16D,0x16E,0x16F,0x170,0x171,0x172,0x173,0x174,
 0x07D,0x089,0x08A,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0A2,0x0AE,0x0AF,0x0B0,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x010,0x000,0x034,0x000,0x058,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x022,0x000,0x046,0x000,0x058,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x021,0x000,0x045,0x000,0x065,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x033,0x000,0x057,0x000,0x065,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x128,0x128,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x129,0x129,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x12A,0x12B,0x12C,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x12D,0x12D,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x12E,0x12F,0x130,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x131,0x132,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x133,0x134,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x135,0x135,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x136,0x137,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x138,0x139,0x13A,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x13B,0x13C,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x13D,0x13E,0x13F,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x140,0x141,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x142,0x143,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0C9,0x0CA,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0CB,0x0CC,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0CD,0x0CE,0x0CF,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0D0,0x0D1,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0D2,0x0D3,0x0D4,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0D5,0x0D5,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0D6,0x0D7,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0D8,0x0D9,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0DA,0x0DA,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0DB,0x0DC,0x0DD,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0DE,0x0DF,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0E0,0x0E1,0x0E2,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0E3,0x0E4,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0E5,0x0E6,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0B1,0x0B1,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0B2,0x0B2,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0B3,0x0B4,0x0B5,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0B6,0x0B6,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0B7,0x0B8,0x0B9,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0BA,0x0BB,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0BC,0x0BC,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0BD,0x0BD,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0BE,0x0BF,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0C0,0x0C1,0x0C2,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0C3,0x0C3,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0C4,0x0C5,0x0C6,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0C7,0x0C7,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0C8,0x0C8,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x093,0x0AA,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x08B,0x0A4,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0A1,0x0AD,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x090,0x0A8,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x092,0x0A9,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x097,0x0AC,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x094,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x08D,0x0A6,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x096,0x0AB,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x08C,0x0A5,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x095,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x08F,0x0A7,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x091,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x08E,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x108,0x109,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x10A,0x10B,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x10C,0x10D,0x10E,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x10F,0x110,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x111,0x112,0x113,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x114,0x115,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x116,0x117,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x118,0x119,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x11A,0x11B,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x11C,0x11D,0x11E,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x11F,0x120,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x121,0x122,0x123,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x124,0x125,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x126,0x127,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0E9,0x0EA,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0EB,0x0EC,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0ED,0x0EE,0x0EF,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0F0,0x0F1,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0F2,0x0F3,0x0F4,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0F5,0x0F6,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0F7,0x0F7,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0F8,0x0F9,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0FA,0x0FB,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0FC,0x0FD,0x0FE,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x0FF,0x0FF,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x100,0x101,0x102,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x103,0x103,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x104,0x104,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x06E,0x086,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x066,0x07F,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x07C,0x088,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x06B,0x083,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x06D,0x085,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x072,0x072,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x06F,0x06F,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x068,0x081,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x071,0x071,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x067,0x080,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x070,0x087,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x06A,0x082,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x06C,0x084,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x069,0x069,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x011,0x000,0x035,0x000,0x059,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x012,0x000,0x036,0x000,0x05A,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x013,0x000,0x037,0x000,0x05B,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x014,0x000,0x038,0x000,0x05C,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x015,0x016,0x000,0x039,0x03A,0x000,0x05D,0x05F,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x017,0x000,0x03B,0x000,0x05E,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x018,0x000,0x03C,0x000,0x05D,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x019,0x000,0x03D,0x000,0x060,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x01A,0x000,0x03E,0x000,0x061,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x01B,0x01C,0x000,0x03F,0x040,0x000,0x062,0x063,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x01D,0x000,0x041,0x000,0x062,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x01E,0x000,0x042,0x000,0x064,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x01F,0x000,0x043,0x000,0x05F,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x020,0x000,0x044,0x000,0x063,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x023,0x000,0x047,0x000,0x059,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x024,0x000,0x048,0x000,0x05A,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x025,0x000,0x049,0x000,0x05B,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x026,0x000,0x04A,0x000,0x05C,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x027,0x028,0x000,0x04B,0x04C,0x000,0x05D,0x05F,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x029,0x000,0x04D,0x000,0x05E,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x02A,0x000,0x04E,0x000,0x05D,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x02B,0x000,0x04F,0x000,0x060,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x02C,0x000,0x050,0x000,0x061,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x02D,0x02E,0x000,0x051,0x052,0x000,0x062,0x063,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x02F,0x000,0x053,0x000,0x062,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x030,0x000,0x054,0x000,0x064,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x031,0x000,0x055,0x000,0x05F,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
 0x032,0x000,0x056,0x000,0x063,0x000,0x000,0x000,
 0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
};

/**
**	Count of available Tilesets.
*/
global int TilesetsCount=4;

/**
**	Tileset information.
**
**	@see TilesetMax
*/
global Tileset Tilesets[TilesetMax] = {
{
    "tileset-summer"
    ,"summer"
#ifdef NEW_NAMES
    ,"graphic/tilesets/summer/terrain/summer.png"
#else
    ,"graphic/tileset/summer.png"
#endif
    ,TileTableSummer
    ,NULL
    ,NULL
#if 1
    ,16,52,88
    ,34,70,88
#endif
    ,{ 115, 116, 117, 118, 119, 120 }
    ,121, 122, 123
    ,126
    ,{ -1 ,-1 }
    ,{ 153, 154, 155, 156, 157, 158 }
    ,161, 162, 163
    ,166
},
{
    "tileset-winter",
    "winter",		"graphic/tileset/winter.png"
    ,TileTableWinter
    ,NULL
    ,NULL
#if 1
    ,16,52,88
    ,34,70,88
#endif
    ,{ 115, 116, 117, 118, 119, 120 }
    ,121, 122, 123
    ,126
    ,{ -1 ,-1 }
    ,{ 148, 149, 150, 151, 152, 153 }
    ,156, 157, 158
    ,161
},
{
    "tileset-wasteland",
    "wasteland",	"graphic/tileset/wasteland.png"
    ,TileTableWasteland
    ,NULL
    ,NULL
#if 1
    ,16,52,88
    ,34,70,88
#endif
    ,{ 115, 116, 117, 118, 119, 120 }
    ,121, 122, 123
    ,126
    ,{ -1 ,-1 }
    ,{ 150, 151, 152, 153, 154, 155 }
    ,158, 159, 160
    ,163
},
{
    "tileset-swamp",
    "swamp",		"graphic/tileset/swamp.png"
    ,TileTableSwamp
    ,NULL
    ,NULL
#if 1
    ,16,52,88
    ,34,70,88
#endif
    ,{ 115, 116, 117, 118, 119, 120 }
    ,121, 122, 123
    ,126
    ,{ -1 ,-1 }
    ,{ 147, 148, 149, 150, 151, 152 }
    ,155, 156, 157
    ,160
},
};

#endif

/*----------------------------------------------------------------------------
--	Functions
----------------------------------------------------------------------------*/

/**
**	Load tileset and setup TheMap for this tileset.
**
**	@see TheMap, @see Tilesets
*/
global void LoadTileset(void)
{
    int i;
    int n;
    int tile;
    int gap;
    int tiles_per_row;
    unsigned char* data;
    const unsigned short* table;

    //TheMap.Tileset=&Tilesets[TheMap.Terrain];
    //
    //	Find the tileset.
    //
    for( i=0; i<TilesetsCount; ++i ) {
	if( !strcmp(TilesetWcNames[TheMap.Terrain],Tilesets[i].Ident) ) {
	    break;
	}
    }
    if( i==TilesetsCount ) {
	fprintf(stderr,"Tileset `%s' not available\n"
		,TilesetWcNames[TheMap.Terrain]);
	exit(-1);
    }
    TheMap.Tileset=&Tilesets[i];

    //
    //	Load and prepare the tileset
    //

    TheMap.TileData=LoadGraphic(TheMap.Tileset->File);

    //
    //	Calculate number of tiles in graphic tile
    //
    if( TheMap.TileData->Width==626 ) {
	// FIXME: allow 1 pixel gap between the tiles!!
	gap=1;
	tiles_per_row=(TheMap.TileData->Width+1)/(TileSizeX+1);
	TheMap.TileCount=n=tiles_per_row*((TheMap.TileData->Height+1)
		/(TileSizeY+1));
    } else if( TheMap.TileData->Width==527 ) {
	// FIXME: allow 1 pixel gap between the tiles!!
	gap=1;
	tiles_per_row=(TheMap.TileData->Width+1)/(TileSizeX+1);
	TheMap.TileCount=n=tiles_per_row*((TheMap.TileData->Height+1)
		/(TileSizeY+1));
    } else {
	gap=0;
	tiles_per_row=TheMap.TileData->Width/TileSizeX;
	TheMap.TileCount=n=tiles_per_row*(TheMap.TileData->Height
		/TileSizeY);
    }

    DebugLevel2Fn(" %d Tiles in file %s, pro row %d\n"
	    ,TheMap.TileCount,TheMap.Tileset->File,tiles_per_row);

    if( n>MaxTilesInTileset ) {
	fprintf(stderr,"Too many tiles in tileset. Increase MaxTilesInTileset and recompile.\n");
	exit(-1);
    }


    //
    //	Precalculate the graphic starts of the tiles
    //
    data=malloc(n*TileSizeX*TileSizeY);
    TheMap.Tiles=malloc(n*sizeof(*TheMap.Tiles));
    for( i=0; i<n; ++i ) {
	TheMap.Tiles[i]=data+i*TileSizeX*TileSizeY;
    }

    //
    //	Convert the graphic data into faster format
    //
    for( tile=0; tile<n; ++tile ) {
	unsigned char* s;
	unsigned char* d;

	s=((char*)TheMap.TileData->Frames)
		+((tile%tiles_per_row)*(TileSizeX+gap))
		+((tile/tiles_per_row)*(TileSizeY+gap))*TheMap.TileData->Width;
	d=TheMap.Tiles[tile];
	if( d!=data+tile*TileSizeX*TileSizeY ) {
	    abort();
	}
	for( i=0; i<TileSizeY; ++i ) {
	    memcpy(d,s,TileSizeX*sizeof(unsigned char));
	    d+=TileSizeX;
	    s+=TheMap.TileData->Width;
	}
    }

    free(TheMap.TileData->Frames);	// release old memory
    TheMap.TileData->Frames=data;
    TheMap.TileData->Width=TileSizeX;
    TheMap.TileData->Height=TileSizeY*n;

    //
    //	Build the TileTypeTable
    //
    //	FIXME: types are currently hardcoded, use the supplied flags.
    //

    table=TheMap.Tileset->Table;
    TheMap.Tileset->TileTypeTable
	    =calloc(n,sizeof(*TheMap.Tileset->TileTypeTable));

    //
    //	Solid tiles
    //
    for( i=0; i<0x10; ++i ) {
	if( (tile=table[0x010+i]) ) {		// solid light water
	    TheMap.Tileset->TileTypeTable[tile]=TileTypeWater;
	}
	if( (tile=table[0x020+i]) ) {		// solid dark water
	    TheMap.Tileset->TileTypeTable[tile]=TileTypeWater;
	}
	if( (tile=table[0x030+i]) ) {		// solid light coast
	    TheMap.Tileset->TileTypeTable[tile]=TileTypeCoast;
	}
	if( (tile=table[0x040+i]) ) {		// solid dark coast
	    TheMap.Tileset->TileTypeTable[tile]=TileTypeCoast;
	}
	if( (tile=table[0x050+i]) ) {		// solid light ground
	    TheMap.Tileset->TileTypeTable[tile]=TileTypeGrass;
	}
	if( (tile=table[0x060+i]) ) {		// solid dark ground
	    TheMap.Tileset->TileTypeTable[tile]=TileTypeGrass;
	}
	if( (tile=table[0x070+i]) ) {		// solid forest
	    TheMap.Tileset->TileTypeTable[tile]=TileTypeWood;
	}
	if( (tile=table[0x080+i]) ) {		// solid rocks
	    TheMap.Tileset->TileTypeTable[tile]=TileTypeRock;
	}

	if( i<3 && (tile=table[0x090+i]) ) {	// solid human walls
	    TheMap.Tileset->TileTypeTable[tile]=TileTypeHumanWall;
	}
	if( i<3 && (tile=table[0x0A0+i]) ) {	// solid orc walls
	    TheMap.Tileset->TileTypeTable[tile]=TileTypeOrcWall;
	}
	if( i<3 && (tile=table[0x0B0+i]) ) {	// solid human walls
	    TheMap.Tileset->TileTypeTable[tile]=TileTypeHumanWall;
	}
	if( i<3 && (tile=table[0x0C0+i]) ) {	// solid orc walls
	    TheMap.Tileset->TileTypeTable[tile]=TileTypeOrcWall;
	}

	// 00,D0,E0,F0 Unused
    }

    //
    //	Mixed tiles
    //
    for( i=0; i<0xE0; ++i ) {
	if( (tile=table[0x100+i]) ) {		// mixed water
	    TheMap.Tileset->TileTypeTable[tile]=TileTypeWater;
	}
	if( (tile=table[0x200+i]) ) {		// mixed water/coast
	    TheMap.Tileset->TileTypeTable[tile]=TileTypeWater;
	}
	if( (tile=table[0x300+i]) ) {		// mixed coast
	    TheMap.Tileset->TileTypeTable[tile]=TileTypeCoast;
	}
	if( (tile=table[0x400+i]) ) {		// mixed rocks/coast
	    TheMap.Tileset->TileTypeTable[tile]=TileTypeRock;
	}
	if( (tile=table[0x500+i]) ) {		// mixed ground/coast
	    TheMap.Tileset->TileTypeTable[tile]=TileTypeCoast;
	}
	if( (tile=table[0x600+i]) ) {		// mixed ground
	    TheMap.Tileset->TileTypeTable[tile]=TileTypeGrass;
	}
	if( (tile=table[0x700+i]) ) {		// mixed forest/ground
	    TheMap.Tileset->TileTypeTable[tile]=TileTypeWood;
	}
	if( (((i&0xF0)==0x40 || (i&0xF0)==0x90) && (i&0xF)<5)
		|| (i&0xF)<3 ) { 
	    if( (tile=table[0x800+i]) ) {	// mixed human wall
		TheMap.Tileset->TileTypeTable[tile]=TileTypeHumanWall;
	    }
	    if( (tile=table[0x900+i]) ) {	// mixed orc wall
		TheMap.Tileset->TileTypeTable[tile]=TileTypeOrcWall;
	    }
	}
    }

    //
    //	mark the special tiles
    //
    for( i=0; i<6; ++i ) {
	if( (tile=TheMap.Tileset->ExtraTrees[i]) ) {
	    TheMap.Tileset->TileTypeTable[tile]=TileTypeWood;
	}
	if( (tile=TheMap.Tileset->ExtraRocks[i]) ) {
	    TheMap.Tileset->TileTypeTable[tile]=TileTypeRock;
	}
    }
    if( (tile=TheMap.Tileset->TopOneTree) ) {
	TheMap.Tileset->TileTypeTable[tile]=TileTypeWood;
    }
    if( (tile=TheMap.Tileset->MidOneTree) ) {
	TheMap.Tileset->TileTypeTable[tile]=TileTypeWood;
    }
    if( (tile=TheMap.Tileset->BotOneTree) ) {
	TheMap.Tileset->TileTypeTable[tile]=TileTypeWood;
    }
    if( (tile=TheMap.Tileset->TopOneRock) ) {
	TheMap.Tileset->TileTypeTable[tile]=TileTypeRock;
    }
    if( (tile=TheMap.Tileset->MidOneRock) ) {
	TheMap.Tileset->TileTypeTable[tile]=TileTypeRock;
    }
    if( (tile=TheMap.Tileset->BotOneRock) ) {
	TheMap.Tileset->TileTypeTable[tile]=TileTypeRock;
    }

#if 0
    for( i=0; i<TheMap.TileCount; ++i ) {
	printf("%d,",TheMap.Tileset->TileTypeTable[i]);
	if( (i&0x0F)==0xF ) {
	    printf("\n");
	}
    }
#endif

    //
    //	Build wood removement table.
    //
    WoodTable[ 0]= -1;
    WoodTable[ 1]= TheMap.Tileset->BotOneTree;
    WoodTable[ 2]= -1;
    WoodTable[ 3]= table[0x710];
    WoodTable[ 4]= TheMap.Tileset->TopOneTree;
    WoodTable[ 5]= TheMap.Tileset->MidOneTree;
    WoodTable[ 6]= table[0x770];
    WoodTable[ 7]= table[0x790];
    WoodTable[ 8]= -1;
    WoodTable[ 9]= table[0x700];
    WoodTable[10]= -1;
    WoodTable[11]= table[0x720];
    WoodTable[12]= table[0x730];
    WoodTable[13]= table[0x740];
    WoodTable[14]= table[0x7B0];
    WoodTable[15]= table[0x7D0];

    //
    //	Build rock removement table.
    //
    RockTable[ 0]= -1;
    RockTable[ 1]= TheMap.Tileset->BotOneRock;
    RockTable[ 2]= -1;
    RockTable[ 3]= table[0x410];
    RockTable[ 4]= TheMap.Tileset->TopOneRock;
    RockTable[ 5]= TheMap.Tileset->MidOneRock;
    RockTable[ 6]= table[0x470];
    RockTable[ 7]= table[0x490];
    RockTable[ 8]= -1;
    RockTable[ 9]= table[0x400];
    RockTable[10]= -1;
    RockTable[11]= table[0x420];
    RockTable[12]= table[0x430];
    RockTable[13]= table[0x440];
    RockTable[14]= table[0x4B0];
    RockTable[15]= table[0x080];

    RockTable[16]= table[0x4C0];
    RockTable[17]= table[0x460];
    RockTable[18]= table[0x4A0];
    RockTable[19]= table[0x4D0];
}

/**
**	Save solid part of tileset.
*/
local void SaveTilesetSolid(FILE* file,const unsigned short* table
	,const char* name,const char* flag,int start)
{
    int i;
    int j;
    int n;

    fprintf(file,"  ( 'solid \"%s\" %s\n    #(",name,flag);
    for( n=15; n>=0 && !table[start+n] ; n-- ) {
    }
    i=6;
    for( j=0; j<=n; ++j ) {
	i+=fprintf(file," %3d",table[start+j]);
    }
    i+=fprintf(file,"))");

    while( (i+=8)<80 ) {
	fprintf(file,"\t");
    }
    fprintf(file,"; %03X\n",start);
}

/**
**	Save mixed part of tileset.
*/
local void SaveTilesetMixed(FILE* file,const unsigned short* table
	,const char* name1,const char* name2,const char* flag,int start)
{
    int x;
    int i;
    int j;
    int n;

    if( start>=0x9E0 ) {
	return;
    }
    fprintf(file,"  ( 'mixed \"%s\" \"%s\" %s\n",name1,name2,flag);
    for( x=0; x<0x100; x+=0x10 ) {
	if( start+x>=0x9E0 ) {
	    break;
	}
	fprintf(file,"    #(");
	for( n=15; n>=0 && !table[start+x+n] ; n-- ) {
	}
	i=6;
	for( j=0; j<=n; ++j ) {
	    i+=fprintf(file," %3d",table[start+x+j]);
	}
	if( x==0xF0 || (start==0x900 && x==0xD0)) {
	    i+=fprintf(file,"))");
	} else {
	    i+=fprintf(file,")");
	}

	while( (i+=8)<80 ) {
	    fprintf(file,"\t");
	}
	fprintf(file,"; %03X\n",start+x);
    }
}

/**
**	Save the current tileset.
**
**	@param file	Output file.
*/
global void SaveTileset(FILE* file)
{
    const unsigned short* table;
    const Tileset* tileset;
    int i;

    tileset=TheMap.Tileset;
    fprintf(file,"\n;;; -----------------------------------------\n");
    fprintf(file,";;; MODULE: tileset $Id: tileset.c,v 1.5 2000/08/13 16:23:02 johns Exp $\n");

    fprintf(file,"(define-tileset\n  '%s",tileset->Ident);
    i=strlen(tileset->Ident);
    if( i<5 ) {
	fputc('\t',file);
    }
    if( i<13 ) {
	fputc('\t',file);
    }
    fprintf(file,"\t\"%s\"",tileset->Name);
    i=strlen(tileset->Name);
    if( i<7 ) {
	fputc('\t',file);
    }
    fprintf(file,"\t\"%s\"\n",tileset->File);
    fprintf(file,"  ;; Slots\n  '(( 'special\t\t;; Can't be in pud\n");
    fprintf(file,"    'extra-trees #( %d %d %d %d %d %d )\n"
	,tileset->ExtraTrees[0] ,tileset->ExtraTrees[1]
	,tileset->ExtraTrees[2] ,tileset->ExtraTrees[3]
	,tileset->ExtraTrees[4] ,tileset->ExtraTrees[5]);
    fprintf(file,"    'top-one-tree %d 'mid-one-tree %d 'bot-one-tree %d\n"
	,tileset->TopOneTree ,tileset->MidOneTree ,tileset->BotOneTree);
    fprintf(file,"    'removed-tree %d\n",tileset->RemovedTree);
    fprintf(file,"    'growing-tree #( %d %d )\n"
	,tileset->GrowingTree[0] ,tileset->GrowingTree[1]);
    fprintf(file,"    'extra-rocks #( %d %d %d %d %d %d )\n"
	,tileset->ExtraRocks[0] ,tileset->ExtraRocks[1]
	,tileset->ExtraRocks[2] ,tileset->ExtraRocks[3]
	,tileset->ExtraRocks[4] ,tileset->ExtraRocks[5]);
    fprintf(file,"    'top-one-rock %d 'mid-one-rock %d 'bot-one-rock %d\n"
	,tileset->TopOneRock ,tileset->MidOneRock ,tileset->BotOneRock);
    fprintf(file,"    'removed-rock %d )\n",tileset->RemovedRock);

    table=TheMap.Tileset->Table;
    //
    //	Solids
    //
    SaveTilesetSolid(file,table,"unused",		"",		0x00);
    SaveTilesetSolid(file,table,"light-water",		"'water",	0x10);
    SaveTilesetSolid(file,table,"dark-water",		"'water",	0x20);
    SaveTilesetSolid(file,table,"light-coast",		"'no-building",	0x30);
    SaveTilesetSolid(file,table,"dark-coast",		"'no-building",	0x40);
    SaveTilesetSolid(file,table,"light-grass",		"",		0x50);
    SaveTilesetSolid(file,table,"dark-grass",		"",		0x60);
    SaveTilesetSolid(file,table,"forest",		"'forest",	0x70);
    SaveTilesetSolid(file,table,"rocks",		"'rock",	0x80);
    SaveTilesetSolid(file,table,"human-closed-wall",	"'wall",	0x90);
    SaveTilesetSolid(file,table,"orc-closed-wall",	"'wall",	0xA0);
    SaveTilesetSolid(file,table,"human-open-wall",	"'wall",	0xB0);
    SaveTilesetSolid(file,table,"orc-open-wall",	"'wall",	0xC0);
    SaveTilesetSolid(file,table,"unused",		"",		0xD0);
    SaveTilesetSolid(file,table,"unused",		"",		0xE0);
    SaveTilesetSolid(file,table,"unused",		"",		0xF0);

    //
    //	Mixeds
    //
    SaveTilesetMixed(file,table,"dark-water","light-water","'water",	0x100);
    SaveTilesetMixed(file,table,"light-water","light-coast","'coast",	0x200);
    SaveTilesetMixed(file,table,"dark-coast","light-coast","'no-building",0x300);
    SaveTilesetMixed(file,table,"rocks","light-coast","'rock",		0x400);
    SaveTilesetMixed(file,table,"light-coast","light-ground","'no-building",0x500);
    SaveTilesetMixed(file,table,"dark-ground","light-ground","",	0x600);
    SaveTilesetMixed(file,table,"forest","light-ground","'forest",	0x700);
    SaveTilesetMixed(file,table,"human-wall","dark-ground","'wall",	0x800);
    SaveTilesetMixed(file,table,"orc-wall","dark-ground","'wall",	0x900);
    fprintf(file,"  )\n");
    fprintf(file,"  ;; Animated tiles\n");
    fprintf(file,"  '( #( ) ))\n");
}

/**
**	Cleanup the tileset module.
**
**	NOTE: this didn't frees the configuration memory.
*/
global void CleanTileset(void)
{
    VideoFree(TheMap.TileData);
    IfDebug( TheMap.TileData=NULL; );
    free(TheMap.Tiles);
    IfDebug( TheMap.Tiles=NULL; );
}

//@}
